/*
 * Decompiled with CFR 0.152.
 */
package jace.core;

import jace.config.ConfigurableField;
import jace.config.InvokableAction;
import jace.core.Computer;
import jace.core.Device;
import jace.core.Motherboard;
import jace.core.VideoWriter;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class Video
extends Device {
    BufferedImage video;
    VideoWriter currentWriter;
    Graphics screen;
    private byte floatingBus = 0;
    private int width = 560;
    private int height = 192;
    private int x = 0;
    protected int y = 0;
    public static int CYCLES_PER_LINE;
    public static int TOTAL_LINES;
    public static int APPLE_CYCLES_PER_LINE;
    public static int APPLE_SCREEN_LINES;
    public static int HBLANK;
    public static int VBLANK;
    int vPeriod = 0;
    int hPeriod = 0;
    public static int[] textOffset;
    public static int[] hiresOffset;
    public static int[] textRowLookup;
    public static int[] hiresRowLookup;
    private boolean screenDirty;
    private boolean lineDirty;
    private boolean isVblank = false;
    static VideoWriter[][] writerCheck;
    private boolean writerChanged;
    int scannerAddress;
    @ConfigurableField(name="Waits per cycle", category="Advanced", description="Adjust the delay for the scanner")
    public static int waitsPerCycle;
    @ConfigurableField(name="Hblank X offset", category="Advanced", description="Adjust where the hblank period starts relative to the start of the line")
    public static int hblankOffsetX;
    @ConfigurableField(name="Hblank Y offset", category="Advanced", description="Adjust which line the HBLANK starts on (0=current, 1=next, etc)")
    public static int hblankOffsetY;

    public Video() {
        this.suspend();
        this.video = new BufferedImage(560, 192, 1);
        this.vPeriod = 0;
        this.hPeriod = 0;
        this.screenDirty = true;
        this.lineDirty = true;
        this.writerChanged = true;
        Thread updateThread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (Video.this.screen == null || Video.this.video == null) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(Video.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                while (true) {
                    if (!Video.this.screenDirty && !Video.this.isVblank) {
                        try {
                            Thread.sleep(2L);
                        }
                        catch (InterruptedException ex) {
                            Logger.getLogger(Video.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        continue;
                    }
                    Video.this.screen.drawImage(Video.this.video, 0, 0, Video.this.width, Video.this.height, null);
                    Video.this.screenDirty = false;
                }
            }
        });
        updateThread.start();
    }

    public void setWidth(int w) {
        this.width = w;
    }

    public void setHeight(int h) {
        this.height = h;
    }

    public void setScreen(Graphics g) {
        this.screen = g;
    }

    public VideoWriter getCurrentWriter() {
        return this.currentWriter;
    }

    public void setCurrentWriter(VideoWriter currentWriter) {
        this.currentWriter = currentWriter;
        this.writerChanged = true;
        this.resume();
    }

    protected abstract void vblankStart();

    protected abstract void vblankEnd();

    public abstract void hblankStart(BufferedImage var1, int var2, boolean var3);

    public void setScannerLocation(int loc) {
        this.scannerAddress = loc;
    }

    @Override
    public void tick() {
        this.setFloatingBus(Computer.getComputer().getMemory().read(this.scannerAddress + this.x, false));
        if (this.hPeriod > 0) {
            --this.hPeriod;
            if (this.hPeriod == 0) {
                this.x = -1;
                this.setScannerLocation(this.currentWriter.getYOffset(this.y));
            }
        } else {
            if (!this.isVblank) {
                this.draw();
            }
            if (this.x >= APPLE_CYCLES_PER_LINE - 1) {
                int yy = this.y + hblankOffsetY;
                if (yy < 0) {
                    yy += 192;
                }
                if (yy >= 192) {
                    yy -= 192;
                }
                this.setScannerLocation(this.currentWriter.getYOffset(yy) + hblankOffsetX + (yy < 64 ? 128 : 0));
                this.x = -1;
                if (!this.isVblank) {
                    if (this.lineDirty) {
                        this.screenDirty = true;
                    }
                    this.hblankStart(this.video, this.y, this.lineDirty);
                    this.lineDirty = false;
                    this.currentWriter.clearDirty(this.y);
                }
                this.hPeriod = HBLANK;
                ++this.y;
                if (this.y >= APPLE_SCREEN_LINES) {
                    if (!this.isVblank) {
                        this.y = APPLE_SCREEN_LINES - (TOTAL_LINES - APPLE_SCREEN_LINES);
                        this.writerChanged = false;
                        this.isVblank = true;
                        this.vblankStart();
                        Motherboard.vblankStart();
                    } else {
                        this.y = 0;
                        this.isVblank = false;
                        this.vblankEnd();
                        Motherboard.vblankEnd();
                    }
                }
            }
        }
        ++this.x;
    }

    public abstract void configureVideoMode();

    protected static int byteDoubler(byte b) {
        int num = (b & 0x40) << 6 | (b & 0x20) << 5 | (b & 0x10) << 4 | (b & 8) << 3 | (b & 4) << 2 | (b & 2) << 1 | b & 1;
        return num | num << 1;
    }

    private void draw() {
        if (this.writerChanged || this.currentWriter.isRowDirty(this.y)) {
            this.lineDirty = true;
            this.currentWriter.displayByte(this.video, this.x, this.y, textOffset[this.y], hiresOffset[this.y]);
        }
        this.setWaitCycles(waitsPerCycle);
        this.doPostDraw();
    }

    public static int calculateHiresOffset(int y) {
        return Video.calculateTextOffset(y >> 3) + ((y & 7) << 10);
    }

    public static int calculateTextOffset(int y) {
        return ((y & 7) << 7) + 40 * (y >> 3);
    }

    public static int identifyTextRow(int y) {
        return (y >> 7) + ((y & 0x7F) / 40 << 3);
    }

    public static int identifyHiresRow(int y) {
        int blockOffset = Video.identifyTextRow(y & 0x3FF);
        if (blockOffset > 23) {
            return -1;
        }
        return (y >> 10 & 7) + (blockOffset << 3);
    }

    public abstract void doPostDraw();

    private void updateScreen() {
        if (this.screenDirty) {
            this.screen.drawImage(this.video, 0, 0, this.width, this.height, null);
        }
        this.screenDirty = false;
        this.writerChanged = false;
    }

    public byte getFloatingBus() {
        return this.floatingBus;
    }

    private void setFloatingBus(byte floatingBus) {
        this.floatingBus = floatingBus;
    }

    @InvokableAction(name="Refresh screen", category="display", description="Marks screen contents as changed, forcing full screen redraw", alternatives="redraw")
    public void markDirty() {
        this.lineDirty = true;
        this.screenDirty = true;
    }

    static {
        int i;
        CYCLES_PER_LINE = 65;
        TOTAL_LINES = 262;
        APPLE_CYCLES_PER_LINE = 40;
        APPLE_SCREEN_LINES = 192;
        HBLANK = CYCLES_PER_LINE - APPLE_CYCLES_PER_LINE;
        VBLANK = (TOTAL_LINES - APPLE_SCREEN_LINES) * CYCLES_PER_LINE;
        writerCheck = new VideoWriter[40][192];
        textOffset = new int[192];
        hiresOffset = new int[192];
        textRowLookup = new int[1024];
        hiresRowLookup = new int[8192];
        for (i = 0; i < 192; ++i) {
            Video.textOffset[i] = Video.calculateTextOffset(i >> 3);
            Video.hiresOffset[i] = Video.calculateHiresOffset(i);
        }
        for (i = 0; i < 1024; ++i) {
            Video.textRowLookup[i] = Video.identifyTextRow(i);
        }
        for (i = 0; i < 8192; ++i) {
            Video.hiresRowLookup[i] = Video.identifyHiresRow(i);
        }
        waitsPerCycle = 0;
        hblankOffsetX = -29;
        hblankOffsetY = 1;
    }
}

